/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.fabric;

import com.mojang.brigadier.CommandDispatcher;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.DataLoaderBase;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.commands.AccessoriesCommands;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.fabric.DataLoaderImpl;
import io.wispforest.accessories.fabric.ExtraEntityTrackingEvents;
import io.wispforest.accessories.impl.AccessoriesCapabilityImpl;
import io.wispforest.accessories.impl.AccessoriesEventHandler;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.InstanceEndec;
import io.wispforest.accessories.menu.AccessoriesMenuTypes;
import io.wispforest.accessories.menu.ArmorSlotTypes;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.client.InvalidateEntityCache;
import io.wispforest.accessories.utils.ManagedEndecDataLoader;
import io.wispforest.owo.serialization.CodecUtils;
import java.util.Iterator;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleFactory;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.fabricmc.fabric.api.item.v1.DefaultItemComponentEvents;
import net.fabricmc.fabric.api.lookup.v1.entity.EntityApiLookup;
import net.minecraft.class_1271;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import org.apache.logging.log4j.util.TriConsumer;

public class AccessoriesFabric
implements ModInitializer {
    public static final AttachmentType<AccessoriesHolderImpl> HOLDER_ATTACHMENT_TYPE;
    public static final EntityApiLookup<AccessoriesCapability, Void> CAPABILITY;

    public void onInitialize() {
        Accessories.init();
        AccessoriesNetworking.init();
        ManagedEndecDataLoader.init(AccessoriesNetworking.CHANNEL, playerConsumer -> ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> playerConsumer.accept(player)));
        AccessoriesDataComponents.init();
        AccessoriesMenuTypes.registerMenuType();
        Accessories.registerCriteria();
        AccessoriesCommands.registerCommandArgTypes();
        ArmorSlotTypes.INSTANCE.registerAccessories(consumer -> RegistryEntryAddedCallback.event((class_2378)class_7923.field_41178).register((arg_0, arg_1, arg_2) -> ((TriConsumer)consumer).accept(arg_0, arg_1, arg_2)));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> AccessoriesCommands.registerCommands((CommandDispatcher<class_2168>)dispatcher, registryAccess));
        UseItemCallback.EVENT.register((player, level, hand) -> {
            class_1271<class_1799> holder = AccessoriesEventHandler.attemptEquipFromUse(player, hand);
            if (holder.method_5467().method_23665()) {
                player.method_6122(hand, (class_1799)holder.method_5466());
            }
            return holder;
        });
        UseEntityCallback.EVENT.register((player, level, hand, entity, hitResult) -> AccessoriesEventHandler.attemptEquipOnEntity(player, hand, entity));
        ServerTickEvents.START_WORLD_TICK.register(AccessoriesEventHandler::onWorldTick);
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> {
            if (!joined) {
                return;
            }
            AccessoriesEventHandler.dataSync(null, player);
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            Iterator iterator = class_7923.field_41177.iterator();
            while (iterator.hasNext()) {
                EntityApiLookup<AccessoriesCapability, Void> lookup = CAPABILITY;
                class_1299 entityType = (class_1299)iterator.next();
                if (lookup.getProvider(entityType) != null) continue;
                lookup.registerForType((entity, unused) -> {
                    if (!(entity instanceof class_1309)) {
                        return null;
                    }
                    class_1309 livingEntity = (class_1309)entity;
                    Map<String, SlotType> slots = EntitySlotLoader.getEntitySlots(livingEntity);
                    if (slots.isEmpty()) {
                        return null;
                    }
                    return new AccessoriesCapabilityImpl(livingEntity);
                }, entityType);
            }
        });
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (!(entity instanceof class_1309)) {
                return;
            }
            class_1309 livingEntity = (class_1309)entity;
            AccessoriesEventHandler.entityLoad(livingEntity, (class_1937)world);
        });
        ExtraEntityTrackingEvents.POST_START_TRACKING.register((trackedEntity, player) -> {
            if (!(trackedEntity instanceof class_1309)) {
                return;
            }
            class_1309 livingEntity = (class_1309)trackedEntity;
            AccessoriesEventHandler.onTracking(livingEntity, player);
        });
        DataLoaderBase.INSTANCE = new DataLoaderImpl();
        DataLoaderBase.INSTANCE.registerListeners();
        DefaultItemComponentEvents.MODIFY.register(context -> AccessoriesEventHandler.setupItems(new AccessoriesEventHandler.AddDataComponentCallback(){

            @Override
            public <T> void addTo(class_1792 item, class_9331<T> componentType, T component) {
                context.modify(item, builder -> builder.method_57840(componentType, component));
            }
        }));
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> AccessoriesNetworking.CHANNEL.serverHandle((class_1657)player).send((Record)new InvalidateEntityCache(player.method_5628())));
        Accessories.RULE_KEEP_ACCESSORY_INVENTORY = GameRuleRegistry.register((String)"accessories.keepAccessoryInventory", (class_1928.class_5198)class_1928.class_5198.field_24094, (class_1928.class_4314)GameRuleFactory.createBooleanRule((boolean)false));
    }

    static {
        CAPABILITY = EntityApiLookup.get((class_2960)Accessories.of("capability"), AccessoriesCapability.class, Void.class);
        HOLDER_ATTACHMENT_TYPE = AttachmentRegistry.builder().initializer(AccessoriesHolderImpl::of).persistent(CodecUtils.toCodec(InstanceEndec.constructed(AccessoriesHolderImpl::new))).copyOnDeath().buildAndRegister(Accessories.of("inventory_holder"));
    }
}

